# -*- coding: utf-8 -*-
"""
Created on Tue May 21 14:40:29 2019

@author: adijkstra
"""
"""
NOTE!!!! THIS CODE ONLY WORKS WHEN YOUR X-AXIS DATA IS EQUALLY SPACED
"""

import numpy as np
from numpy import exp, linspace, random
import pandas as pd
import matplotlib.pyplot as plt
import os
from scipy.optimize import curve_fit
from scipy.special import gamma
from scipy import signal
from scipy.ndimage import convolve1d
from scipy.ndimage import correlate1d

#============Get the current directory
path = os.getcwd()
print("The current directory is: %s" % path )
#==================================================================



#specify from which file the data comes
fileNamePow = 'H06138_LICorrIntensityPowers.txt'
importedFilePow=np.array(pd.read_csv(fileNamePow, sep='\t', header=None))

"""

#Plot the normalized graphs to show what I am working with
plt.plot(energyData, Normalized4K, 'r^')
plt.plot(energyData, Normalized280K, 'b^')
plt.axis([0.2, 0.55, 0,1.2])
plt.show()

"""


def gaussian(x, amp, cen, wid):
    return amp * exp(-(x-cen)**2 / wid)

def simpleDOS(E, Eg, A, normalized=True):
    if np.isscalar(E) == False:
        DOS=np.zeros(int(np.size(E)))
        n=0
        for i in E:
            if i<=Eg:
                DOS[n]=0.0
            else:
                DOS[n]=np.multiply(A,np.sqrt(i-Eg))
                
            n+=1
        return DOS     

    else:
        return np.multiply(A,np.sqrt(E-Eg))

    
def fermiDirac(E,Eg,T,broadeningFactor=1.0, Eshift=0):
    k=8.61733e-5 #[eV/K]
    return np.divide(1,(1+np.exp(np.divide(((E-Eg-Eshift)*broadeningFactor),(k*T)))))

def urbachTail(E, Eg, gam, theta=1, normalized=False):
    N=np.divide(1,(2*gam*gamma(1+np.divide(1,theta)))) #This normalization factor makes that the area under neath the graph remains to be 1
    if normalized == False:
        return np.multiply(np.exp(-np.power(np.absolute((np.divide((E-Eg),gam))),theta)),N)
    elif normalized == True:
        return np.divide(np.multiply(np.exp(-np.power(np.absolute((np.divide((E-Eg),gam))),theta)),N), np.amax(np.multiply(np.exp(-np.power(np.absolute((np.divide((E-Eg),gam))),theta)),N)))
    
    
def tailedDOS(E, Eg, A, gam, theta=1, normalized=False):
    #First make an array that will be used to define the urback tail, important is that I know the length of the array and that the peak is at te exact center
    EStepsize=np.divide((E[40]-E[0]),40) #Get the energy stepsize
    HalfLength = int(1000) #Choose a value for the length of the array used for the peak function 
    EDataUT = np.zeros(HalfLength*2) #define the array that will be used and fill the array with energy values with zero at the center of the array.
    for i in range (HalfLength):
        EDataUT[i]=(i-HalfLength+0.5)*EStepsize
        EDataUT[i+HalfLength]=(i+0.5)*EStepsize
    #Now the FULL convolution can be done between the urbach tail and the simple DOS    
    tailDOS=np.convolve(urbachTail(EDataUT, 0, gam, theta), simpleDOS(E, Eg, A), 'full')/sum(urbachTail(EDataUT, 0, gam, theta))
    #The convolution is now exactly shifted by half of the urbach tail length minus one cell So now I correct for this and we can return the array.
    tailDOS=tailDOS[HalfLength-1:]
    tailDOS=tailDOS[0:int(np.size(E))]
    #Then return the signal
    if normalized == False:
        return tailDOS
    elif normalized == True:
        return np.divide(tailDOS,np.amax(tailDOS))
    
def simpleDOS_FD(E, Eg, A, T, Eshift=0, normalized=False):
    if normalized == False:
        return np.multiply(simpleDOS(E,Eg,A),fermiDirac(E,Eg,T, Eshift))
    elif normalized == True:
        return np.divide(np.multiply(simpleDOS(E,Eg,A),fermiDirac(E,Eg,T, Eshift)),np.amax(np.multiply(simpleDOS(E,Eg,A),fermiDirac(E,Eg,T, Eshift))))

def tailedDOS_FD(E, Eg, A, T, gam, theta=1, Eshift=0.0, normalized=False):
    if normalized == False:
        return np.multiply(tailedDOS(E, Eg, A, gam, theta),fermiDirac(E,Eg,T,Eshift))
    elif normalized == True:
        return np.divide(np.multiply(tailedDOS(E, Eg, A, gam, theta),fermiDirac(E,Eg,T,Eshift)),np.amax(np.multiply(tailedDOS(E, Eg, A, gam, theta),fermiDirac(E,Eg,T,Eshift))))

def tailedAbsorptivity (E, Eg, A, gam, theta=1, Eshift=0, d=1, normalized=False):
    #d is a characeristic length scale of absorption
    if normalized == False:
        return 1-np.exp(-tailedDOS(E, Eg, A, gam, theta)*d)
    elif normalized == True:
        return np.divide((1-np.exp(-tailedDOS(E, Eg, A, gam, theta)*d)),np.amax(1-np.exp(-tailedDOS(E, Eg, A, gam, theta)*d)))
    
def simpleAbsorptivity (E, Eg, A, Eshift=0, d=1, normalized=False):
    #d is a characeristic length scale of absorption in paper used as fitting parameter
    if normalized == False:
        return 1-np.exp(-simpleDOS(E, Eg, A)*d)
    elif normalized == True:
        return np.divide((1-np.exp(-simpleDOS(E, Eg, A)*d)),np.amax(1-np.exp(-simpleDOS(E, Eg, A)*d)))

   
def tailedAbsortivityOccCorr(E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    k=8.61733e-5 #[eV/K]
    #d is a characeristic length scale of absorption in paper used as fitting parameter
    temp=np.multiply(tailedDOS(E, Eg, A, gam, theta),(1-np.divide(2,np.exp(np.divide((E-Dmu),(2*np.multiply(k,T))))+1)))
    temp=1-np.exp(-temp*d)
    #temp=(1-np.divide(2,np.exp(np.divide((E-Dmu),(2*np.multiply(k,T))))+1))
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,temp[-1])


def tailedAbsortivityOccCorrAsym(E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    #d is a characeristic length scale of absorption in paper used as fitting parameter
    p=1
    Pn=p
    Pp=1-p
    #Pn=0.5
    #Pp=0.5
    #temp=np.multiply(tailedDOS(E, Eg, A, gam, theta),(1-np.divide(1,np.exp(np.divide(Pn*(E-Dmu),(np.multiply(kb,T))))+1)-np.divide(1,np.exp(np.divide(Pp*(E-Dmu),(np.multiply(kb,T))))+1)))
    temp=np.multiply(tailedDOS(E, Eg, A, gam, theta),(1-fermiDirac(E,Dmu,T,Pn)-fermiDirac(E,Dmu,T,Pp)))
    temp=1-np.exp(-temp*d)
    #temp=(1-np.divide(2,np.exp(np.divide((E-Dmu),(2*np.multiply(k,T))))+1))
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,temp[-1])  
    
def LSW_tailedAbs_PL (E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    k=8.61733e-5 #[eV/K]
    temp=np.divide(np.multiply(np.power(E,2),tailedAbsortivityOccCorrAsym(E, Eg, A, T, gam, Dmu, d, theta, Eshift=0.0, normalized=False)),(np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1))
    #temp=np.divide(1,np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1)
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,np.amax(temp))
    
def LSW_tailedAbsNoCorr_PL (E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    k=8.61733e-5 #[eV/K]
    temp=np.divide(np.multiply(np.power(E,2),tailedAbsorptivity(E, Eg, A, gam, theta, Eshift=0.0, normalized=False)),(np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1))
    #temp=np.divide(1,np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1)
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,np.amax(temp[3000:]))
    

"""
==================================================
===============SET THE VARIABLES==================
==================================================
"""
BGEnergy=0.35
Temperature=150
gam=0.006
DeltaMu=0.3
theta=1
A=5
EfShift=0.00
startCell=50
dataLength=140
absorptionLength=1

#energyData= energyData[startCell:dataLength]
#Normalized280K=Normalized280K[startCell:dataLength]
#Normalized4K=Normalized4K[startCell:dataLength]

#This is a scale I use to get a higher density of data points
energySimu = np.arange(0, 1.0, 0.001)
energySimu = energySimu.astype(np.float)

"""
==================================================
===============SET THE VARIABLES==================
==================================================
"""


#Calculate some spectra for learning purposes
"""
#Calculate arrays based on artificial high density data
calculatedDOS_simu= simpleDOS(energySimu, BGEnergy, A, normalized=True)
calculatedDOS_FD_simu = simpleDOS_FD(energySimu, BGEnergy, A, Temperature, normalized=True)
calculated_FD_simu = fermiDirac(energySimu, BGEnergy, Temperature)
calculated_UT_simu = urbachTail(energySimu, BGEnergy, gam, theta, True)
calculated_tDOS_simu = tailedDOS(energySimu, BGEnergy, A, gam, theta)
calculated_tDOS_FD_simu = tailedDOS_FD(energySimu, BGEnergy, A, Temperature, gam, theta, EfShift, normalized=True)
calculated_tAbsorptivity_simu = tailedAbsorptivity(energySimu, BGEnergy, A, gam, theta, EfShift,absorptionLength, normalized=True)
calculated_tailedAbsortivityOccCorr_simu = tailedAbsortivityOccCorr(energySimu, BGEnergy, A, Temperature, gam, DeltaMu, theta, EfShift, absorptionLength, normalized=True)
calculated_sAbsorptivity_simu = simpleAbsorptivity(energySimu, BGEnergy, A, EfShift,absorptionLength,  normalized=True)
calculated_LSW_tailedAbs_PL_simu = LSW_tailedAbs_PL(energySimu, BGEnergy, A, Temperature, gam, DeltaMu, absorptionLength,  theta, Eshift=0, normalized=True)
calculated_LSW_tailedAbsNoCorr_PL_simu = LSW_tailedAbsNoCorr_PL (energySimu, BGEnergy, A, Temperature, gam, DeltaMu, absorptionLength,  theta, Eshift=0, normalized=True)


plt.figure(1)
#Plot fermi dirac
plt.plot(energySimu, calculated_FD_simu, 'b', label='Fermi Dirac')
#Plot simple DOS
plt.plot(energySimu, calculatedDOS_simu, 'g', label='DOS')
#Plot simple DOS multiplied with fermi dirac
plt.plot(energySimu, calculatedDOS_FD_simu, 'r', label='simple DOS FD')
#Plot urbach tail function
#plt.plot(energySimu, calculated_UT_simu, 'y', label='UT')
#Plot urbach tail function convoluted with simple DOS
#plt.plot(energySimu, calculated_tDOS_simu, 'b--', label='UT conv DOS')
#Plot tailed DOS multiplied with fermi dirac
#plt.plot(energySimu, calculated_tDOS_FD_simu, 'r--', label='UT conv DOS FD')
#Plot simple absorptivity
#plt.plot(energySimu, calculated_sAbsorptivity_simu, 'b--', label='simple Abs')
#Plot tailed absorptivity
#plt.plot(energySimu, calculated_tAbsorptivity_simu, 'b', label='tailed Abs')
plt.legend(loc='right')
plt.axis([0.3, 0.4, 0 , 1])
plt.show()


plt.figure(2)
plt.plot(energySimu, calculated_LSW_tailedAbs_PL_simu, 'r', label='LSW_tailedAbsOC')
plt.plot(energySimu, calculated_LSW_tailedAbsNoCorr_PL_simu, label='LSW_tailedAbs')
plt.plot(energySimu, calculated_tAbsorptivity_simu, 'y', label='tailedAbsty')
plt.plot(energySimu, calculated_tDOS_FD_simu, label='tDOS_FD')
#plt.plot(energySimu, calculated_tDOS_simu, 'r', label='UT conv DOS')
plt.plot(energySimu  ,calculated_tailedAbsortivityOccCorr_simu,'g', label='tailed Absty OC')
plt.axvline(x=BGEnergy,linewidth=2.0, dashes=(5,5))  #mark the bandgap
plt.legend(loc='best')
plt.axis([0.28, 0.42, 0 , 1])
plt.show()

"""

#Make a figure that show the smoothening of the DOS
"""
plt.figure(3, figsize=(10, 5))
plt.subplot(1, 2, 1)
plt.plot(energySimu, urbachTail(energySimu, BGEnergy, 0.001, theta, normalized=True), label='T(y=0.001)')
plt.plot(energySimu, urbachTail(energySimu, BGEnergy, 0.01, theta, normalized=True), label='T(y=0.01)')
plt.plot(energySimu, urbachTail(energySimu, BGEnergy, 0.1, theta, normalized=True), label='T(y=0.1)')
plt.axis([0.2, 0.60, 0, 1.2])
plt.legend(loc='best')
plt.subplot(1, 2, 2)
plt.plot(energySimu, tailedDOS(energySimu, BGEnergy, A, 0.001, theta, normalized=True), label='tailDOS(y=0.001)')
plt.plot(energySimu, tailedDOS(energySimu, BGEnergy, A, 0.01, theta, normalized=True), label='tailDOS(y=0.01)')
plt.plot(energySimu, tailedDOS(energySimu, BGEnergy, A, 0.1, theta, normalized=True), label='tailDOS(y=0.1)')
plt.plot(energySimu, calculatedDOS_simu, label='simpleDOS')
plt.axis([0.2, 0.60, 0.001, 1.2])
plt.legend(loc='best')
plt.show()
"""


"""
#Calculate arrays based on experimental energy array
calculatedDOS= simpleDOS(energyData, BGEnergy, 3)
calculatedDOS_FD = simpleDOS_FD(energyData, BGEnergy, 10, Temperature)
calculated_FD = fermiDirac(energyData, BGEnergy, Temperature)
calculated_UT = urbachTail(energyData, BGEnergy, gam, theta)
calculated_tDOS = tailedDOS(energyData, BGEnergy, A, gam, theta)
calculated_tDOS_FD = tailedDOS_FD(energyData, BGEnergy, A, Temperature, gam, theta, EfShift, False)
"""





"""


#Try fitting with original simple DOS model
InVal_DOS_FD_4K = [BGEnergy, 80000, Temperature]  # for [amp, cen, wid]
InVal_DOS_FD_280K = [BGEnergy, 80000, Temperature]  # for [amp, cen, wid]
BestVal_DOS_FD_4K, covar = curve_fit(simpleDOS_FD, energyData, Normalized4K, p0=InVal_DOS_FD_4K)
BestVal_DOS_FD_280K, covar = curve_fit(simpleDOS_FD, energyData, Normalized280K, p0=InVal_DOS_FD_280K)


#Now try fitting with the more advanced model with an Urbach tail
InVal_TDOS_FD_4K = [BGEnergy, A, Temperature, gam]  # for [amp, cen, wid]
InVal_TDOS_FD_280K = [BGEnergy, A, Temperature, gam]  # for [amp, cen, wid]
BestVal_TDOS_FD_4K, covar = curve_fit(tailedDOS_FD, energyData, Normalized4K, p0=InVal_TDOS_FD_4K)
BestVal_TDOS_FD_280K, covar = curve_fit(tailedDOS_FD, energyData, Normalized280K, p0=InVal_TDOS_FD_280K)

print("Best values DOS_FD:")
print("4K: " + str(BestVal_DOS_FD_4K))
print("280K: " + str(BestVal_DOS_FD_280K))
print("Best values DOS_FD_tail:")
print("4K: " + str(BestVal_TDOS_FD_4K))
print("280K: " + str(BestVal_TDOS_FD_280K))

#Make arrays for all the fitted results
fitted_DOS_FD_4K=simpleDOS_FD(energyData, BestVal_DOS_FD_4K[0], BestVal_DOS_FD_4K[1], BestVal_DOS_FD_4K[2])
fitted_DOS_FD_280K=simpleDOS_FD(energyData, BestVal_DOS_FD_280K[0], BestVal_DOS_FD_280K[1], BestVal_DOS_FD_280K[2])
fitted_TDOS_FD_4K=tailedDOS_FD(energyData, BestVal_TDOS_FD_4K[0], BestVal_TDOS_FD_4K[1], BestVal_TDOS_FD_4K[2], BestVal_TDOS_FD_4K[3])
fitted_TDOS_FD_280K=tailedDOS_FD(energyData, BestVal_TDOS_FD_280K[0], BestVal_TDOS_FD_280K[1], BestVal_TDOS_FD_280K[2], BestVal_TDOS_FD_280K[3])


plt.figure(2)
#Plot the measuredPL
plt.plot(energyData, Normalized4K, 'g', label='4K Experiment')
plt.plot(energyData, Normalized280K, 'r', label='280K Experiment')
#Plot the fitted result based on simple DOS FD
plt.plot(energyData, fitted_DOS_FD_4K, 'g*', label='Fitted sDOS_FD 4K')
plt.plot(energyData, fitted_DOS_FD_280K, 'r*', label='Fitted sDOS_FD 280K')
# Plot the fitted results based on tailed DOS FD
plt.plot(energyData, fitted_TDOS_FD_4K, 'g--', label='Fitted TDOS_FD 4K')
plt.plot(energyData, fitted_TDOS_FD_280K, 'r--', label='Fitted TDOS_FD 280K')
#Plot the potential PL shape in own resolution
#plt.plot(energyData, calculated_tDOS_FD, 'b^', label='4K peak model ExRes')
#Plot the potential PL shape in simulation resolution
#plt.plot(energySimu, calculated_tDOS_FD_simu, 'b--', label='4K peak model SimuRes')
#set the legend
plt.legend(loc='upper right')
plt.axis([0.25, 0.50, 0, 1.2])
plt.show()
os.chdir(path)
"""








"""
================================================
===========Loop to fit all the data=============
================================================
"""




###############################################################
#Fitting with the Lasher-Stern-Wurfel model
#Power dependent
####################################################


#==================Setting fitting parameters
BGEnergy=0.27
Temperature=20
gam=0.02
theta=1
A=100
EfShift=0.00
startCell=50
dataLength=140
absorptionLength=1
DeltaMu=0.38


#Choose whether to fit the data or simply import it from the previous file
FIT_DATA=True
PRINT_PLOTS=False
EXPORT_RAW_FITS=True


#============================

#make a new directory of all the output of the PL_V_T data
path = os.getcwd()
print("The current directory is: %s" % path )
newnewfolderpath=path+"/LSW_PL_fitting_P-series"
try:
    os.mkdir(newnewfolderpath)
except OSError:
    print('Creation of folder failed')
else:
    print('Succesfully created folder')
try:
    os.chdir(newnewfolderpath)
except OSError:
    print('Failed to change directories to new folder')
else:    
    print('Changed directory to new new folder: ' + newnewfolderpath)

#Check how many things I imported
importSizePow=np.size(importedFilePow[:1])-2

#Make result arrays existing out of zeros
results_LSW_PL = np.zeros(((importSizePow),10),dtype=float)

#Make initial values
InVal_LSW_PL = [BGEnergy, A, Temperature, gam, DeltaMu]  # for [amp, cen, wid]

#Energy scale
energyData = importedFilePow[7:,1]
energyData = energyData.astype(np.float)  #turn into a float data format

#Loop to fit with the simple model
for i in range (0, importSizePow):
    
    #If I do not want the data to be fitted then use the fitted data from a previous session!
    if FIT_DATA == False:
        results_LSW_PL=np.array(pd.read_csv("Fitting_results_" + fileNamePow, sep='\t', header=1))
        #results_LSW_PL=results_LSW_PL[2:]
        results_LSW_PL = results_LSW_PL.astype(np.float)
        #print(results_LSW_PL)
    
    #If the option was chosen to fit the data then all the spectra are fitted if not then the data was imported
    if FIT_DATA==True:
        #initialize fitting result array
        BestVal_LSW_PL = np.zeros(5)
        
        #BestVal_DOS_FD, covar = curve_fit(simpleDOS_FD, energyData, importedFileTemp[7:,i+2], p0=InVal_sDOS_FD)
        data=importedFilePow[7:,i+2]
        data_original = data.astype(np.float)
        data=np.divide(data_original,np.amax(data_original))
        FitStartElement=50
        FitEndElement=250
        
        try: BestVal_LSW_PL, covar = curve_fit(LSW_tailedAbs_PL, energyData[FitStartElement:FitEndElement], data[FitStartElement:FitEndElement], p0=InVal_LSW_PL)
        except:
            print("Something happend!")
            
        #Save the power of the spectrum to the fit and excitation densitythe fitting results
        results_LSW_PL[i,2:7]=BestVal_LSW_PL
        results_LSW_PL[i,0]=importedFilePow[4,i+2] #This is the power
        results_LSW_PL[i,1]=importedFilePow[5,i+2] #This is the excitation density
        print("Finished with Power: " + str(importedFilePow[4,i+2]))
        #calculate the fitted spectrum
        calculated_LSW_PL = LSW_tailedAbs_PL(energyData, BestVal_LSW_PL[0], BestVal_LSW_PL[1], BestVal_LSW_PL[2], BestVal_LSW_PL[3], BestVal_LSW_PL[4])
        calculated_LSW_PL_normalized = LSW_tailedAbs_PL(energyData, BestVal_LSW_PL[0], BestVal_LSW_PL[1], BestVal_LSW_PL[2], BestVal_LSW_PL[3], BestVal_LSW_PL[4], normalized=True)
        #Determine at which energy the maximum occurs
        results_LSW_PL[i,7]=energyData[np.argmax(calculated_LSW_PL)]
        #Determine the intensity by integrating the fitted graph and multiplying with the height
        results_LSW_PL[i,8]=np.multiply(np.multiply(np.trapz(calculated_LSW_PL, energyData),np.amax(data_original)),np.amax(calculated_LSW_PL))
        #Also determine the intensity by integrating the original
        results_LSW_PL[i,9]=np.trapz(data_original, energyData)
            
            #If I did not fit I have to initialize some parameters    
    else:
        #This line is just to make sure that BestVal_biGauss_PL has the right value when imported
        BestVal_LSW_PL=results_LSW_PL[i,2:7]
        #This line is to get the right data selected when the fitting parameters are imported
        data=importedFilePow[7:,i+2]
        data_original = data.astype(np.float)
        data=np.divide(data_original,np.amax(data_original))
        #calculate the fitted spectrum
        calculated_LSW_PL = LSW_tailedAbs_PL(energyData, BestVal_LSW_PL[0], BestVal_LSW_PL[1], BestVal_LSW_PL[2], BestVal_LSW_PL[3], BestVal_LSW_PL[4])
        calculated_LSW_PL_normalized = LSW_tailedAbs_PL(energyData, BestVal_LSW_PL[0], BestVal_LSW_PL[1], BestVal_LSW_PL[2], BestVal_LSW_PL[3], BestVal_LSW_PL[4], normalized=True)

    
    if PRINT_PLOTS==True:
        plt.figure(figsize=(15, 5)) #define the frame size
        plt.subplot(1, 3, 1)            #Set the subplot
        plt.plot(energyData, data, 'r')
        plt.plot(energyData, LSW_tailedAbs_PL(energyData, BestVal_LSW_PL[0], BestVal_LSW_PL[1], BestVal_LSW_PL[2], BestVal_LSW_PL[3], BestVal_LSW_PL[4]), 'b--')
        plt.text(0.26, 1.15, "P= " + "{:.6s}".format(importedFilePow[5,i+2]) + "W/cm2", horizontalalignment='left', verticalalignment='top', fontsize=18)
        #Lines indicating the fitting interval
        plt.axvline(x=energyData[FitStartElement],linewidth=1.0, color='g')
        plt.axvline(x=energyData[FitEndElement],linewidth=1.0, color='g')
        #Line indicating the bandgap
        plt.axvline(x=BestVal_LSW_PL[0],linewidth=2.0, dashes=(5,5))
        plt.axis([0.2, 0.6, 0.0, 1.2])
        plt.subplot(1, 3, 2)
        plt.semilogy(energyData, data, 'r')
        plt.semilogy(energyData, LSW_tailedAbs_PL(energyData, BestVal_LSW_PL[0], BestVal_LSW_PL[1], BestVal_LSW_PL[2], BestVal_LSW_PL[3], BestVal_LSW_PL[4]), 'b--')
        #Lines indicating the fitting interval
        plt.axvline(x=energyData[FitStartElement],linewidth=1.0, color='g')
        plt.axvline(x=energyData[FitEndElement],linewidth=1.0, color='g')
        #Line indicating the bandgap
        plt.axvline(x=BestVal_LSW_PL[0],linewidth=2.0, dashes=(5,5))
        plt.axis([0.2, 0.6, 0.001, 1.2])
        plt.subplot(1, 3, 3)
        plt.semilogy(energySimu,tailedAbsortivityOccCorr(energySimu, BestVal_LSW_PL[0], BestVal_LSW_PL[1], BestVal_LSW_PL[2], BestVal_LSW_PL[3], BestVal_LSW_PL[4], d=1, theta=1, Eshift=0, normalized=True), label='Absty_OcCor')
        plt.semilogy(energySimu,tailedAbsorptivity (energySimu, BestVal_LSW_PL[0],BestVal_LSW_PL[1], BestVal_LSW_PL[3], theta=1, Eshift=0, d=1, normalized=True), label='TailedAbsty')
        plt.semilogy(energySimu,simpleAbsorptivity (energySimu, BestVal_LSW_PL[0],BestVal_LSW_PL[1], normalized=True), label='SimpleAbsty')
        plt.legend(loc='left')
        plt.axis([0.3, 0.41, 0.01, 1.1])
        #Line indicating the bandgap
        plt.axvline(x=BestVal_LSW_PL[0],linewidth=2.0, dashes=(5,5), color='g')
        #line indicating the fermisplitting
        plt.axvline(x=BestVal_LSW_PL[4],linewidth=2.0, dashes=(5,5), color='r')
        #save the figure in the current directory
        plt.savefig('LSW_PL_'+"P= " + "{:.6s}".format(importedFilePow[5,i+2]) + 'Wcm2.png')
        plt.show()
        


print(results_LSW_PL)


#create a .txt file with the same name as the h5 file and save in the same location
Header='\r\n'.join(["Power\tExcitationDensity\tBandgap\tScalingFactor\tPLTemperature\tGamma\tDeltaMu\tPeakCenter\tIntensity\ttrapz Intensity", "mW\tW/cm2\teV\t\tK\teV\t-\teV\tm\teV\ta.u.\ta.u."])
np.savetxt("Fitting_results_" + fileNamePow, results_LSW_PL, fmt='%.5e', delimiter='\t', header=Header, newline='\r\n', comments='')

if EXPORT_RAW_FITS:
    #Check how long the energy axis will be
    number_of_simu_datapoints=np.size(energySimu)
    #Then check how many fits there have been made and initialize an array for the output.
    Fit_plot_data=np.zeros((number_of_simu_datapoints+1, importSizePow+1), dtype=float)
    #set the first column with the energy data and the first row with the powers
    Fit_plot_data[1:,0]=energySimu
    Fit_plot_data[0,1:]=results_LSW_PL[:,1]
    #now calculate the output spectrum for all the fitted spectra and save in the output array
    for i in range(importSizePow):
        Fit_plot_data[1:,i+1]=LSW_tailedAbs_PL(energySimu, results_LSW_PL[i,2], results_LSW_PL[i,3], results_LSW_PL[i,4], results_LSW_PL[i,5], results_LSW_PL[i,6]) 
    np.savetxt("Fitting_rawdata_" + fileNamePow, Fit_plot_data, fmt='%.5e', delimiter='\t', newline='\r\n', comments='')


plt.figure(2, figsize=(6, 16), dpi=80, facecolor='w', edgecolor='k')

for i in range (0, importSizePow):
    data=importedFilePow[7:,i+2]
    data = data.astype(np.float)
    data = np.divide(data, np.amax(data))
    plt.plot(energyData, data+0.5*i, 'r')
    plt.plot(energyData, LSW_tailedAbs_PL(energyData, results_LSW_PL[i,2], results_LSW_PL[i,3], results_LSW_PL[i,4], results_LSW_PL[i,5], results_LSW_PL[i,6], normalized=True)+0.5*i, 'b--')
    plt.text(0.59, 0.1+0.5*i, "P= " + "{:.6s}".format(importedFilePow[5,i+2]) + "W/cm2", horizontalalignment='right', verticalalignment='bottom', fontsize=12)
plt.axis([0.2, 0.60, 0, 12.5])
#save the figure in the current directory
plt.savefig('PL_LSW_PL_P-Stack.png')
plt.show
os.chdir(path)


#This is just a temorary check
plt.figure(3, figsize=(18, 6))
plt.subplot(1,3,1)
plt.semilogx(results_LSW_PL[:,1],results_LSW_PL[:,2], "bh", label="Bandgap" )
plt.semilogx(results_LSW_PL[:,1],results_LSW_PL[:,6], "r.", label="DeltaMu" )
plt.semilogx(results_LSW_PL[:,1],results_LSW_PL[:,7], "gv",label="Peak" )
plt.legend(loc="best")
plt.xlabel('Excitation density (W/cm2)')
plt.ylabel('Energy (eV)')
plt.subplot(1,3,2)
plt.loglog(results_LSW_PL[:,1],results_LSW_PL[:,8], "bh", label="Fitted Intensity" )
plt.loglog(results_LSW_PL[:,1],results_LSW_PL[:,9], "r.", label="Raw Intensity" )
plt.legend(loc="best")
plt.xlabel('Excitation density (W/cm2)')
plt.ylabel('Intensity (a.u.)')
plt.subplot(1,3,3)
plt.loglog(results_LSW_PL[:,1],results_LSW_PL[:,4], "r.", label="Electron temperature" )
plt.xlabel('Excitation density (W/cm2)')
plt.ylabel('Temperature (K)')
plt.legend(loc="best")
plt.savefig('PL_LSW_BG_DMu.png')
plt.show()

plt.figure(4, figsize=(18,6))
plt.subplot(1,3,1)
plt.semilogx(results_LSW_PL[:,1],results_LSW_PL[:,6]-results_LSW_PL[:,2], "bh", label="DeltaMu-BG" )
plt.xlabel('Excitation density (W/cm2)')
plt.ylabel('DeltaMu-BG (eV)')
plt.legend(loc="best")
plt.subplot(1,3,2)
plt.semilogx(results_LSW_PL[:,1],results_LSW_PL[:,5], "bh", label="Gamma" )
plt.xlabel('Excitation density (W/cm2)')
plt.ylabel('Gamma (eV)')
plt.legend(loc="best")
plt.subplot(1,3,3)
plt.semilogx(results_LSW_PL[:,1],results_LSW_PL[:,3], "bh", label="Scaling constant" )
plt.xlabel('Excitation density (W/cm2)')
plt.ylabel('Scaling constant')
plt.legend(loc="best")
plt.savefig('PL_Gamma_Scaling.png')
plt.savefig('PL_LSW_BGDmu_Gamma_scaling.png')
plt.show()